package ru.yandex.market.logshatter.parser.front.errorBooster.reportRenderer;

import com.google.gson.JsonObject;
import ru.yandex.market.logshatter.parser.front.errorBooster.LogLevel;
import ru.yandex.market.logshatter.parser.front.errorBooster.Parser;
import ru.yandex.market.logshatter.parser.front.errorBooster.Runtime;
import ru.yandex.market.logshatter.parser.front.errorBooster.schema.ErrorsSchema;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.regex.Pattern;

import static ru.yandex.market.logshatter.parser.ParseUtils.sipHash64;

public class ErrorsContainer extends ErrorsSchema {
    private static final Pattern STACKTRACE_URL_PREFIX_PATTERN = Pattern.compile(
        "\\/place\\/db\\/iss3\\/instances\\/[^/]+\\/(templates\\/YxWeb\\/)?(templates-bstr\\/[\\d]*\\/)?",
        Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);

    public boolean fill(JsonObject jsonObject, Map<String, String> meta) {
        logLevel = LogLevel.ERROR;

        String rawMessage = prepareRawMessage(jsonObject.get("message").getAsString());

        int index = rawMessage.indexOf("\n");
        if (index == -1) {
            originalMessage = rawMessage;
        } else { // has \n
            originalMessage = rawMessage.substring(0, index);
            originalStackTrace = rawMessage;
        }

        message = prepareMessage(originalMessage);
        messageId = sipHash64(message);

        stackTrace = prepareStacktrace(originalStackTrace);
        stackTraceId = sipHash64(stackTrace);

        fileId = sipHash64(file);

        runtime = Runtime.NODEJS;
        parser = Parser.REPORT_RENDERER;

        if (meta.containsKey("ua")) {
            userAgent = meta.get("ua");
        }

        userAgentId = sipHash64(userAgent);

        if (meta.containsKey("block")) {
            block = meta.get("block");
        }

        if (meta.containsKey("method")) {
            method = meta.get("method");
        }

        if (meta.containsKey("file")) {
            file = meta.get("file");
        }

        if (meta.containsKey("source")) {
            source = meta.get("source");
        }

        return true;
    }

    public String prepareRawMessage(String rawMessage) {
        try {
            // https://stackoverflow.com/questions/11257509
            rawMessage = rawMessage.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
            rawMessage = URLDecoder.decode(rawMessage, "utf-8");
        } catch (UnsupportedEncodingException ignored) {}

        rawMessage = rawMessage.trim();

        return rawMessage;
    }

    public String prepareMessage(String message) {
        message = replaceUrls(message, "MESSAGE");

        return message;
    }

    public String prepareStacktrace(String stackTrace) {
        stackTrace = STACKTRACE_URL_PREFIX_PATTERN.matcher(stackTrace).replaceAll("/");
        stackTrace = replaceUrls(stackTrace, "STACKTRACE");
        return stackTrace;
    }
}

