package ru.yandex.market.logshatter.parser.front.errorBooster.reportRenderer;

import com.google.common.base.Splitter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import org.apache.commons.lang3.ArrayUtils;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.front.errorBooster.schema.Schema;
import ru.yandex.market.logshatter.useragent.UserAgentDetector;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ErrorsParser implements LogParser {

    public ErrorsParser() {}

    @Override
    public TableDescription getTableDescription() {
        return Schema.TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        JsonParser jsonParser = new JsonParser();
        JsonObject projects = jsonParser.parse(context.getParam("projects")).getAsJsonObject();
        JsonObject platforms = jsonParser.parse(context.getParam("platforms")).getAsJsonObject();

        for (String subLine : Splitter.on("\n").split(line)) {
            JsonObject jsonObject;
            try {
                JsonElement jsonElement = jsonParser.parse(subLine);

                if (!jsonElement.isJsonObject()) {
                    return;
                }

                jsonObject = jsonElement.getAsJsonObject();
                JsonObject format = jsonObject.get("scarab:format").getAsJsonObject();

                if (!format.get("type").getAsString().equals("json") || !format.get("version").getAsString().equals("2")) {
                    return;
                }
            } catch (JsonParseException ignored) {
                return;
            }

            if (!jsonObject.get("level").getAsString().equals("ERROR")) {
                return;
            }

            Map<String, String> meta = new HashMap<>();
            if (jsonObject.has("meta")) {
                try {
                    JsonArray jsonMeta = jsonObject.getAsJsonArray("meta");
                    for (int i = 0; i < jsonMeta.size(); i++) {
                        JsonObject item = jsonMeta.get(i).getAsJsonObject();

                        meta.put(item.get("name").getAsString(), item.get("value").getAsString());
                    }
                } catch (Exception ignored) {}
            }

            UserAgentDetector userAgentDetector = context.getUserAgentDetector();

            CommonContainer commonContainer = new CommonContainer(userAgentDetector);

            if (!commonContainer.fill(jsonObject, meta, projects, platforms)) {
                return;
            }

            ErrorsContainer errorsContainer = new ErrorsContainer();

            if (!errorsContainer.fill(jsonObject, meta)) {
                return;
            }

            Long timestampMilliseconds = ParseUtils.parseLong(jsonObject.get("timestamp").getAsString(), 0L);

            context.write(
                new Date(timestampMilliseconds),
                ArrayUtils.addAll(commonContainer.serialize(), errorsContainer.serialize())
            );
        }
    }
}
