package ru.yandex.market.logshatter.parser.front.errorBooster.schema;


import com.google.common.primitives.UnsignedLong;
import org.apache.commons.lang.StringUtils;
import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickhouse.ddl.enums.EnumColumnType;
import ru.yandex.market.logshatter.parser.front.errorBooster.Environment;
import ru.yandex.market.logshatter.parser.front.errorBooster.Platform;
import ru.yandex.market.logshatter.useragent.UserAgentDetector;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Arrays;
import java.util.Map;
import java.util.Collections;

import static ru.yandex.market.logshatter.parser.ParseUtils.parseTestBuckets;

public class CommonSchema {
    public static final String COLUMN_PROJECT = "project";
    protected String project = "";

    public static final String COLUMN_SERVICE = "service";
    protected String service = "";

    public static final String COLUMN_PAGE = "page";
    protected String page = "";

    public static final String COLUMN_PLATFORM = "platform";
    protected Platform platform = Platform.UNKNOWN;

    public static final String COLUMN_URL = "url";
    protected String url = "";

    public static final String COLUMN_URL_ID = "url_id";
    protected UnsignedLong urlId = UnsignedLong.valueOf(0);

    public static final String COLUMN_VHOST = "vhost";
    protected String vhost = "";

    public static final String COLUMN_ENVIRONMENT = "environment";
    protected Environment environment = Environment.UNKNOWN;

    public static final String COLUMN_TEST_IDS = "test_ids";
    protected List<Integer> testIds = new ArrayList<>();

    public static final String COLUMN_EXP_FLAGS = "exp_flgs";
    protected List<String> expFlags = new ArrayList<>();

    public static final String COLUMN_BROWSER_ENGINE = "browser_engine";
    protected String browserEngine = "";

    public static final String COLUMN_BROWSER_ENGINE_VERSION = "browser_engine_version";
    protected String browserEngineVersion = "";

    public static final String COLUMN_BROWSER_NAME = "browser_name";
    protected String browserName = "";

    public static final String COLUMN_BROWSER_VERSION = "browser_version";
    protected String browserVersion = "";

    public static final String COLUMN_BROWSER_VERSION_MAJOR = "browser_version_major";
    protected String browserVersionMajor = "";

    public static final String COLUMN_BROWSER_BASE = "browser_base";
    protected String browserBase = "";

    public static final String COLUMN_OS_FAMILY = "os_family";
    protected String osFamily = "";

    public static final String COLUMN_OS_NAME = "os_name";
    protected String osName = "";

    public static final String COLUMN_OS_VERSION = "os_version";
    protected String osVersion = "";

    public static final String COLUMN_OS_VERSION_MAJOR = "os_version_major";
    protected String osVersionMajor = "";

    public static final String COLUMN_DEVICE_NAME = "device_name";
    protected String deviceName = "";

    public static final String COLUMN_DEVICE_VENDOR = "device_vendor";
    protected String deviceVendor = "";

    public static final String COLUMN_IN_APP_BROWSER = "in_app_browser";
    protected Boolean inAppBrowser = false;

    public static final String COLUMN_IS_ROBOT = "is_robot";
    protected Boolean isRobot = false;

    public static final String COLUMN_IS_TV = "is_tv";
    protected Boolean isTv = false;

    public static final String COLUMN_IS_TABLET = "is_tablet";
    protected Boolean isTablet = false;

    public static final String COLUMN_IS_TOUCH = "is_touch";
    protected Boolean isTouch = false;

    public static final String COLUMN_IS_MOBILE = "is_mobile";
    protected Boolean isMobile = false;

    public static final String COLUMN_IS_ADBLOCK = "is_adblock";
    protected Boolean isAdblock = false;

    public static final String COLUMN_VERSION = "version";
    protected String version = "";

    public static final String COLUMN_REGION = "region";
    protected Integer region = 0;

    public static final String COLUMN_REQUEST_ID = "request_id";
    protected String requestId = "";

    public static final String COLUMN_REQUEST_ID_HASH = "request_id_hash";
    protected UnsignedLong requestIdHash = UnsignedLong.valueOf(0);

    public static final String COLUMN_YANDEXUID = "yandexuid";
    protected UnsignedLong yandexuid = UnsignedLong.valueOf(0);

    public static final String COLUMN_KV_KEYS = "kv_keys";
    protected List<String> kvKeys = new ArrayList<>();

    public static final String COLUMN_KV_VALUES = "kv_values";
    protected List<String> kvValues = new ArrayList<>();

    public static final String COLUMN_IS_INTERNAL = "is_internal";
    protected Boolean isInternal = false;

    public static final Column[] fields = {
        new Column(COLUMN_PROJECT, ColumnType.String),
        new Column(COLUMN_SERVICE, ColumnType.String),
        new Column(COLUMN_PAGE, ColumnType.String),
        new Column(COLUMN_PLATFORM, EnumColumnType.enum8(Platform.class)),
        new Column(COLUMN_URL, ColumnType.String),
        new Column(COLUMN_URL_ID, ColumnType.UInt64),
        new Column(COLUMN_VHOST, ColumnType.String),
        new Column(COLUMN_ENVIRONMENT, EnumColumnType.enum8(Environment.class),
            String.format("'%s'", Environment.UNKNOWN.toString())),
        new Column(COLUMN_TEST_IDS, ColumnType.ArrayUInt32),
        new Column(COLUMN_EXP_FLAGS, ColumnType.ArrayString),
        new Column(COLUMN_BROWSER_ENGINE, ColumnType.String),
        new Column(COLUMN_BROWSER_ENGINE_VERSION, ColumnType.String),
        new Column(COLUMN_BROWSER_NAME, ColumnType.String),
        new Column(COLUMN_BROWSER_VERSION, ColumnType.String),
        new Column(COLUMN_BROWSER_VERSION_MAJOR, ColumnType.String),
        new Column(COLUMN_BROWSER_BASE, ColumnType.String),
        new Column(COLUMN_OS_FAMILY, ColumnType.String),
        new Column(COLUMN_OS_NAME, ColumnType.String),
        new Column(COLUMN_OS_VERSION, ColumnType.String),
        new Column(COLUMN_OS_VERSION_MAJOR, ColumnType.String),
        new Column(COLUMN_DEVICE_NAME, ColumnType.String),
        new Column(COLUMN_DEVICE_VENDOR, ColumnType.String),
        new Column(COLUMN_IN_APP_BROWSER, ColumnType.UInt8),
        new Column(COLUMN_IS_ROBOT, ColumnType.UInt8),
        new Column(COLUMN_IS_TV, ColumnType.UInt8),
        new Column(COLUMN_IS_TABLET, ColumnType.UInt8),
        new Column(COLUMN_IS_TOUCH, ColumnType.UInt8),
        new Column(COLUMN_IS_MOBILE, ColumnType.UInt8),
        new Column(COLUMN_IS_ADBLOCK, ColumnType.UInt8),
        new Column(COLUMN_VERSION, ColumnType.String),
        new Column(COLUMN_REGION, ColumnType.UInt32),
        new Column(COLUMN_REQUEST_ID, ColumnType.String),
        new Column(COLUMN_REQUEST_ID_HASH, ColumnType.UInt64),
        new Column(COLUMN_YANDEXUID, ColumnType.UInt64),
        new Column(COLUMN_KV_KEYS, ColumnType.ArrayString),
        new Column(COLUMN_KV_VALUES, ColumnType.ArrayString),
        new Column(COLUMN_IS_INTERNAL, ColumnType.UInt8),
    };

    public Object[] serialize() {
        return new Object[]{
            project,
            service,
            page,
            platform,
            url,
            urlId,
            vhost,
            environment,
            testIds,
            expFlags,
            browserEngine,
            browserEngineVersion,
            browserName,
            browserVersion,
            browserVersionMajor,
            browserBase,
            osFamily,
            osName,
            osVersion,
            osVersionMajor,
            deviceName,
            deviceVendor,
            inAppBrowser,
            isRobot,
            isTv,
            isTablet,
            isTouch,
            isMobile,
            isAdblock,
            version,
            region,
            requestId,
            requestIdHash,
            yandexuid,
            kvKeys,
            kvValues,
            isInternal
        };
    }

    protected void addKvItem(String key, String value) {
        kvKeys.add(key);
        kvValues.add(value);
    }

    protected String getVhost(String url) {
        String vhost = "";

        try {
            vhost = new URI(url).getHost();
            if (vhost == null) {
                vhost = "";
            }
        } catch (URISyntaxException ignored) {}

        return vhost;
    }

    protected void fillUaTraits(UserAgentDetector detector, String userAgent) {
        if (StringUtils.isEmpty(userAgent)) {
            return;
        }

        Map<String, String> uatraits = detector.detect(userAgent);
        String browserName = uatraits.getOrDefault(UserAgentDetector.BROWSER_NAME, "");
        if (!StringUtils.equals(browserName, "Unknown")) {
            this.browserName = browserName;
        }

        String browserEngine = uatraits.getOrDefault(UserAgentDetector.BROWSER_ENGINE, "");
        if (!StringUtils.equals(browserEngine, "Unknown")) {
            this.browserEngine = browserEngine;
        }

        String osFamily = uatraits.getOrDefault(UserAgentDetector.OS_FAMILY, "");
        if (!StringUtils.equals(osFamily, "Unknown")) {
            this.osFamily = osFamily;
        }

        browserBase = uatraits.getOrDefault(UserAgentDetector.BROWSER_BASE, "");
        browserEngineVersion = uatraits.getOrDefault(UserAgentDetector.BROWSER_ENGINE_VERSION, "");
        browserVersion = uatraits.getOrDefault(UserAgentDetector.BROWSER_VERSION, "");
        osName = uatraits.getOrDefault(UserAgentDetector.OS_NAME, "");
        osVersion = uatraits.getOrDefault(UserAgentDetector.OS_VERSION, "");
        isMobile = Boolean.parseBoolean(uatraits.getOrDefault(UserAgentDetector.IS_MOBILE, null));
        inAppBrowser = Boolean.parseBoolean(uatraits.getOrDefault(UserAgentDetector.IN_APP_BROWSER, null));
        isRobot = Boolean.parseBoolean(uatraits.getOrDefault(UserAgentDetector.IS_ROBOT, null));
        isTv = Boolean.parseBoolean(uatraits.getOrDefault(UserAgentDetector.IS_TV, null));
        isTablet = Boolean.parseBoolean(uatraits.getOrDefault(UserAgentDetector.IS_TABLET, null));
        isTouch = Boolean.parseBoolean(uatraits.getOrDefault(UserAgentDetector.IS_TOUCH, null));
        isMobile = Boolean.parseBoolean(uatraits.getOrDefault(UserAgentDetector.IS_MOBILE, null));
        deviceName = uatraits.getOrDefault(UserAgentDetector.DEVICE_NAME, "").trim();
        deviceVendor = uatraits.getOrDefault(UserAgentDetector.DEVICE_VENDOR, "").trim();
        browserVersionMajor = getBrowserVersionMajor(browserName, browserVersion);
        osVersionMajor = getOsVersionMajor(osFamily, osVersion);
    }

    public String getOsVersionMajor(String osFamily, String osVersion) {
        int firstDotIndex = osVersion.indexOf('.');
        int secondDotIndex = osVersion.indexOf('.', firstDotIndex + 1);

        if (firstDotIndex < 0) {
            return osVersion;
        }

        String osVersionFirst = osVersion.substring(0, firstDotIndex);

        if (osFamily.equals("Tizen") || osFamily.equals("MacOS") || (osFamily.equals("Android") && osVersionFirst.equals("4"))) {
            if (secondDotIndex > 0) {
                return osVersion.substring(0, secondDotIndex);
            }

            return osVersion;
        }

        return osVersionFirst;
    }

    public String getBrowserVersionMajor(String browserName, String browserVersion) {
        int firstDotIndex = browserVersion.indexOf('.');
        int secondDotIndex = browserVersion.indexOf('.', firstDotIndex + 1);

        if (firstDotIndex < 0) {
            return browserVersion;
        }

        if (browserName.equals("YandexSearch")) {
            return browserVersion.substring(0, firstDotIndex + 2);
        } else if (browserName.equals("YandexBrowser")) {
            if (secondDotIndex > 0) {
                return browserVersion.substring(0, secondDotIndex);
            }

            return browserVersion;
        }

        return browserVersion.substring(0, firstDotIndex);
    }

    public List<Integer> getTestIds(String slots) {
        List<Integer> testIds = Arrays.asList(parseTestBuckets(slots));
        Collections.sort(testIds);

        return testIds;
    }
}
