package ru.yandex.market.logshatter.parser.front.errorBooster.schema;

import com.google.common.primitives.UnsignedLong;
import org.apache.commons.lang.StringUtils;
import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickhouse.ddl.enums.EnumColumnType;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.front.errorBooster.LogLevel;
import ru.yandex.market.logshatter.parser.front.errorBooster.Parser;
import ru.yandex.market.logshatter.parser.front.errorBooster.Runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorsSchema {
    private static final Pattern URL_PATTERN = Pattern.compile(
        "(http(s?):\\/\\/|www\\.)([^\\s'\")]*)",
        Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);

    public static final String COLUMN_MESSAGE = "message";
    protected String message = "";

    public static final String COLUMN_MESSAGE_ID = "message_id";
    protected UnsignedLong messageId = UnsignedLong.valueOf(0);

    public static final String COLUMN_ORIGINAL_MESSAGE = "original_message";
    protected String originalMessage = "";

    // Урлы, найденные в ошибке
    public static final String COLUMN_ERROR_URLS_KEYS = "error_urls_keys";
    protected ArrayList<String> errorUrlsKeys = new ArrayList<>();

    public static final String COLUMN_ERROR_URLS_VALUES = "error_urls_values";
    protected ArrayList<String> errorUrlsValues = new ArrayList<>();

    // клиент/сервер/мобильное приложение
    public static final String COLUMN_RUNTIME = "runtime";
    protected Runtime runtime = Runtime.BROWSERJS;

    // Enum8('error' = 1, 'warning' = 2, 'debug' = 3, 'info' = 4, 'critical' = 5),
    public static final String COLUMN_LEVEL = "level";
    protected LogLevel logLevel = LogLevel.UNKNOWN;

    public static final String COLUMN_FILE = "file";
    protected String file = "";

    public static final String COLUMN_FILE_ID = "file_id";
    protected UnsignedLong fileId = UnsignedLong.valueOf(0);

    public static final String COLUMN_BLOCK = "block";
    protected String block = "";

    public static final String COLUMN_METHOD = "method";
    protected String method = "";

    public static final String COLUMN_LINE = "line";
    protected Integer line = 0;

    public static final String COLUMN_COL = "col";
    protected Integer col = 0;

    public static final String COLUMN_STACK_TRACE = "stack_trace";
    protected String stackTrace = "";

    public static final String COLUMN_STACK_TRACE_ID = "stack_trace_id";
    protected UnsignedLong stackTraceId = UnsignedLong.valueOf(0);

    public static final String COLUMN_ORIGINAL_STACK_TRACE = "original_stack_trace";
    protected String originalStackTrace = "";

    public static final String COLUMN_USER_AGENT = "user_agent";
    protected String userAgent = "";

    public static final String COLUMN_USER_AGENT_ID = "user_agent_id";
    protected UnsignedLong userAgentId = UnsignedLong.valueOf(0);

    // источник проблемы, например название внешней ручки
    public static final String COLUMN_SOURCE = "source";
    protected String source = "";

    // метод источника ошибки
    public static final String COLUMN_SOURCE_METHOD = "source_method";
    protected String sourceMethod = "";

    //Тип источника ошибки(логическая, network, внешние ручки...)
    public static final String COLUMN_SOURCE_TYPE = "source_type";
    protected String sourceType = "";

    public static final String COLUMN_CLIENT_TIMESTAMP = "client_timestamp";
    protected Integer clientTimestamp = 0;

    public static final String COLUMN_REPLACED_URLS_KEYS = "replaced_url_keys";
    protected List<String> replacedUrlKeys = new ArrayList<>();

    public static final String COLUMN_REPLACED_URLS_VALUES = "replaced_url_values";
    protected List<String> replacedUrlValues = new ArrayList<>();

    public static final String COLUMN_IP = "ip";
    protected Long ip = 0L;

    public static final String COLUMN_PARSER = "parser";
    protected Parser parser = Parser.UNKNOWN;

    public static final Column[] fields = {
        new Column(COLUMN_MESSAGE, ColumnType.String),
        new Column(COLUMN_MESSAGE_ID, ColumnType.UInt64),
        new Column(COLUMN_ORIGINAL_MESSAGE, ColumnType.String),
        new Column(COLUMN_ERROR_URLS_KEYS, ColumnType.ArrayString),
        new Column(COLUMN_ERROR_URLS_VALUES, ColumnType.ArrayString),
        new Column(COLUMN_RUNTIME, EnumColumnType.enum8(Runtime.class)),
        new Column(COLUMN_LEVEL, EnumColumnType.enum8(LogLevel.class)),
        new Column(COLUMN_FILE, ColumnType.String),
        new Column(COLUMN_FILE_ID, ColumnType.UInt64),
        new Column(COLUMN_BLOCK, ColumnType.String),
        new Column(COLUMN_METHOD, ColumnType.String),
        new Column(COLUMN_LINE, ColumnType.UInt32),
        new Column(COLUMN_COL, ColumnType.UInt32),
        new Column(COLUMN_STACK_TRACE, ColumnType.String),
        new Column(COLUMN_STACK_TRACE_ID, ColumnType.UInt64),
        new Column(COLUMN_ORIGINAL_STACK_TRACE, ColumnType.String),
        new Column(COLUMN_USER_AGENT, ColumnType.String),
        new Column(COLUMN_USER_AGENT_ID, ColumnType.UInt64),
        new Column(COLUMN_SOURCE, ColumnType.String),
        new Column(COLUMN_SOURCE_METHOD, ColumnType.String),
        new Column(COLUMN_SOURCE_TYPE, ColumnType.String),
        new Column(COLUMN_CLIENT_TIMESTAMP, ColumnType.UInt32),
        new Column(COLUMN_REPLACED_URLS_KEYS, ColumnType.ArrayString),
        new Column(COLUMN_REPLACED_URLS_VALUES, ColumnType.ArrayString),
        new Column(COLUMN_IP, ColumnType.UInt32),
        new Column(COLUMN_PARSER, EnumColumnType.enum8(Parser.class),
            String.format("'%s'", Parser.UNKNOWN.toString())),
    };

    public Object[] serialize() {
        return new Object[]{
            message,
            messageId,
            originalMessage,
            errorUrlsKeys,
            errorUrlsValues,
            runtime,
            logLevel,
            file,
            fileId,
            block,
            method,
            line,
            col,
            stackTrace,
            stackTraceId,
            originalStackTrace,
            userAgent,
            userAgentId,
            source,
            sourceMethod,
            sourceType,
            clientTimestamp,
            replacedUrlKeys,
            replacedUrlValues,
            ip,
            parser
        };
    }

    protected String replaceUrls(String text, String key) {
        return replaceUrls(text, extractUrls(text), key);
    }

    protected List<String> extractUrls(String text) {
        List<String> containedUrls = new ArrayList<String>();
        Matcher matcher = URL_PATTERN.matcher(text);

        while (matcher.find()) {
            containedUrls.add(
                text.substring(matcher.start(0), matcher.end(0))
            );
        }
        return containedUrls;
    }

    protected String replaceUrls(String text, List<String> urls, String type) {
        int index = 0;

        for (String url : urls) {
            text = StringUtils.replace(text, url, "{{REPLACED_" + type + "_URL_" + index + "}}");
            index++;
        }

        addReplacedUrls(urls, type);
        return text;
    }

    protected void addReplacedUrls(List<String> urls, String type) {
        int index = 0;

        for (String url : urls) {
            replacedUrlKeys.add(type + "_" + index);
            replacedUrlValues.add(url);
            index++;
        }
    }

    public int prepareClientTimestamp(String timestamp) {
        long timestampLong = TimeUnit.MILLISECONDS.toSeconds(ParseUtils.parseLong(timestamp, 0L));

        if (timestampLong <= Integer.MAX_VALUE) {
            return (int) timestampLong;
        }
        return 0;
    }
}
