package ru.yandex.market.logshatter.parser.front.errorBooster.stackParser;

import java.util.Objects;

public class StackFrame {
    /**
     * Название участка кода (метода, функции, модуля, "global code", "(anonymous)" и т.п.)
     */
    private final String name;
    private final String url;
    private final int line;
    private final int col;

    public StackFrame(String name, String url, int line, int col) {
        this.name = name;
        this.url = url;
        this.line = line;
        this.col = col;
    }

    public String getName() {
        return name;
    }

    public String getUrl() {
        return url;
    }

    public int getLine() {
        return line;
    }

    public int getCol() {
        return col;
    }

    @Override
    public String toString() {
        return "StackFrame{" + name + " (" + url + ':' + line + ":" + col + ")}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackFrame that = (StackFrame) o;
        return line == that.line &&
            col == that.col &&
            Objects.equals(name, that.name) &&
            Objects.equals(url, that.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, url, line, col);
    }
}
