package ru.yandex.market.logshatter.parser.front.helpers;

import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.trace.Environment;

import java.util.Date;

public class AppErrorMetrikaContainer implements MetrikaContainer {
    private String service = "";
    private String requestId = "";
    private String platform = "";
    private Date date;
    private String code = "";
    private String level = "";
    private String message = "";
    private String stackTrace = "";
    private String stackTraceHash = "";
    private String file = "";
    private int lineNumber = 0;
    private String[] tags = {};
    private String[] extraKeys = {};
    private String[] extraValues = {};
    private String revision = "";
    private Environment environment = Environment.UNKNOWN;

    public void writeToContext(ParserContext context) {
        context.write(
            this.getDate(),
            this.getService(),
            context.getHost(),
            this.getRequestId(),
            this.getCode(),
            this.getLevel(),
            this.getMessage(),
            this.getStackTrace(),
            this.getStackTraceHash(),
            this.getFile(),
            this.getLineNumber(),
            this.getTags(),
            this.getExtraKeys(),
            this.getExtraValues(),
            this.getRevision(),
            this.getEnvironment(),
            this.getPlatform()
        );
    }

    public String getService() {
        return service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String reqId) {
        this.requestId = reqId;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private String getStackTrace() {
        return stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    private String getStackTraceHash() {
        return stackTraceHash;
    }

    public void setStackTraceHash(String stackTraceHash) {
        this.stackTraceHash = stackTraceHash;
    }

    public String getFile() {
        return file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    private int getLineNumber() {
        return lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String[] getTags() {
        return tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    private String[] getExtraKeys() {
        return extraKeys;
    }

    public void setExtraKeys(String[] extraKeys) {
        this.extraKeys = extraKeys;
    }

    private String[] getExtraValues() {
        return extraValues;
    }

    public void setExtraValues(String[] extraValues) {
        this.extraValues = extraValues;
    }

    private String getRevision() {
        return revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public Environment getEnvironment() {
        return environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

}
