package ru.yandex.market.logshatter.parser.front.helpers;

import com.google.common.base.Splitter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FrontParserUtils {
    public static Map<String, String> getServiceNames(String source) {
        return Splitter
            .on(',')
            .trimResults()
            .omitEmptyStrings()
            .withKeyValueSeparator(':')
            .split(source);
    }

    public static Set<String> parseSetFromString(String events) {
        if (events == null) {
            return Collections.emptySet();
        }

        return Collections.unmodifiableSet(new HashSet<>(
            Splitter
                .on(',')
                .trimResults()
                .omitEmptyStrings()
                .splitToList(events)
        ));
    }
}
