package ru.yandex.market.logshatter.parser.front.helpers.tableDestription;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickhouse.ddl.enums.EnumColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.trace.Environment;

import java.util.Arrays;

public interface MarketErrors {
    public static final String COLUMN_SERVICE = "service";
    public static final String COLUMN_REQUEST_ID = "request_id";
    public static final String COLUMN_CODE = "code";
    public static final String COLUMN_LEVEL = "level";
    public static final String COLUMN_MESSAGE = "message";
    public static final String COLUMN_STACK_TRACE = "stack_trace";
    public static final String COLUMN_STACK_TRACE_HASH = "stack_trace_hash";
    public static final String COLUMN_FILE = "file";
    public static final String COLUMN_LINE_NO = "line_no";
    public static final String COLUMN_TAGS = "tags";
    public static final String COLUMN_EXTRA_KEYS = "extra_keys";
    public static final String COLUMN_EXTRA_VALUES = "extra_values";
    public static final String COLUMN_REVISION = "revision";
    public static final String COLUMN_HOST = "host";
    public static final String COLUMN_ENVIRONMENT = "environment";
    public static final String COLUMN_PLATFORM = "platform";

    public static final TableDescription DESCRIPTION = TableDescription.createDefault(
        Arrays.asList(COLUMN_SERVICE, COLUMN_ENVIRONMENT),
        new Column(COLUMN_SERVICE, ColumnType.String),
        new Column(COLUMN_HOST, ColumnType.String),
        new Column(COLUMN_REQUEST_ID, ColumnType.String),
        new Column(COLUMN_CODE, ColumnType.String),
        new Column(COLUMN_LEVEL, ColumnType.String),
        new Column(COLUMN_MESSAGE, ColumnType.String),
        new Column(COLUMN_STACK_TRACE, ColumnType.String),
        new Column(COLUMN_STACK_TRACE_HASH, ColumnType.String),
        new Column(COLUMN_FILE, ColumnType.String),
        new Column(COLUMN_LINE_NO, ColumnType.UInt32),
        new Column(COLUMN_TAGS, ColumnType.ArrayString),
        new Column(COLUMN_EXTRA_KEYS, ColumnType.ArrayString),
        new Column(COLUMN_EXTRA_VALUES, ColumnType.ArrayString),
        new Column(COLUMN_REVISION, ColumnType.String),
        new Column(
            COLUMN_ENVIRONMENT,
            EnumColumnType.enum8(Environment.class),
            String.format("'%s'", Environment.UNKNOWN.toString())),
        new Column(COLUMN_PLATFORM, ColumnType.String)
    );
}
