package ru.yandex.market.logshatter.parser.front.logformat;

import java.util.regex.Matcher;

/**
 * @author Insaf Latypov <a href="mailto:saferif@yandex-team.ru"></a>
 * @date 22/09/15
 */
public class LogField {
    private String name;
    private String pattern;
    private String defaultValue;

    public LogField(String name, String pattern) {
        this(name, pattern, null);
    }

    public LogField(String name, String pattern, String defaultValue) {
        this.name = name;
        this.pattern = pattern;
        this.defaultValue = defaultValue;
    }

    @Override
    public String toString() {
        return "(?<" + name + ">" + pattern + ")";
    }

    public String getName() {
        return name;
    }

    public String getValue(Matcher matcher) {
        String value = matcher.group(name);
        return value == null ? defaultValue : value;
    }
}
