package ru.yandex.market.logshatter.parser.front.logformat;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Insaf Latypov <a href="mailto:saferif@yandex-team.ru"></a>
 * @date 22/09/15
 */
public class LogFormat {

    private static final Pattern PLACEHOLDER = Pattern.compile("<<(\\w+?)>>");

    final private Map<String, LogField> fields;
    final private Pattern pattern;

    public LogFormat(String template, LogField... fields) {
        this.fields = new HashMap<>();
        for (LogField field : fields) {
            this.fields.put(field.getName(), field);
        }

        String builtPattern = template;
        Matcher placeholderMatcher;
        while ((placeholderMatcher = PLACEHOLDER.matcher(builtPattern)).find()) {
            String placeholderName = placeholderMatcher.group(1);
            if (!this.fields.containsKey(placeholderName)) {
                throw new LogFormatException("Unmatched field: " + placeholderMatcher.group());
            }
            builtPattern = placeholderMatcher.replaceFirst(this.fields.get(placeholderName).toString());
        }

        pattern = Pattern.compile(builtPattern);
    }

    public Map<String, String> parse(String line) {
        Matcher matcher = pattern.matcher(line);
        if (!matcher.matches()) {
            return null;
        }

        Map<String, String> matches = new HashMap<String, String>();
        for (Map.Entry<String, LogField> field : fields.entrySet()) {
            matches.put(field.getKey(), field.getValue().getValue(matcher));
        }
        return matches;
    }
}
