package ru.yandex.market.logshatter.parser.ir;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.clickhouse.ddl.engine.MergeTree;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 09/03/16
 */
public class ScAgeParser implements LogParser {

    private final DateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z", Locale.US);

    public static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        Arrays.asList("metric"),
        new Column("metric", ColumnType.String),
        new Column("host", ColumnType.String),
        new Column("category", ColumnType.UInt32),
        new Column("time_hours", ColumnType.UInt32),
        new Column("count", ColumnType.UInt32)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String[] splits = line.split("\t");
        Date date = dateFormat.parse(splits[0]);
        String metric = splits[1];
        TimeUnit timeUnit;
        if (metric.contains("Days")) {
            timeUnit = TimeUnit.DAYS;
            metric = metric.replace("Days", "");
        } else if (metric.contains("Hours")) {
            timeUnit = TimeUnit.HOURS;
            metric = metric.replace("Hours", "");
        } else {
            return;
        }
        Integer timeHours = (int) timeUnit.toHours(Integer.valueOf(splits[2]));
        Integer count = Integer.valueOf(splits[3]);
        Integer category = Integer.valueOf(splits[4]);

        context.write(date, metric, context.getHost(), category, timeHours, count);
    }
}
