package ru.yandex.market.logshatter.parser.ir;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.ComplicatedLineParser;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Tatiana Litvinenko <a href="mailto:tanlit@yandex-team.ru"></a>
 * @date 13.08.2015
 */
public class ServerMainAccessLog implements LogParser {
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("method", ColumnType.String),
        new Column("http_code", ColumnType.UInt16),
        new Column("resptime_ms", ColumnType.UInt32)
    );

    private ComplicatedLineParser lineParser = new ComplicatedLineParser();

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    /*
    Log example:
    5.255.217.10 - - [13/Aug/2015:16:56:39 +0300] "POST /enrich HTTP/1.1" 599 - "-" "yandex-super-controller (1.5-246) unstable; urgency=low" 2405961
     */
    @Override
    public void parse(String line, ParserContext context) throws Exception {
        lineParser.setLine(line);

        Date date = dateFormat.parse(lineParser.getStringSurroundedBy('[', ']', true));

        String[] querySplits = lineParser.getStringSurroundedByQuote().split(" ");
        if (querySplits.length != 3) {
            return;
        }
        String method = ParseUtils.extractMethod(querySplits[1]);

        Integer httpCode = Integer.valueOf(lineParser.getStringSurroundedBySpace());
        lineParser.ignoreSurroundedByQuote();
        lineParser.ignoreSurroundedByQuote();

        String respTimeString = lineParser.getStringSurroundedBySpace();
        Integer respTimeMillis;
        if (respTimeString.isEmpty()) {
            respTimeMillis = 0;
        } else {
            respTimeMillis = Integer.valueOf(respTimeString);
        }
        context.write(date, context.getHost(), method, httpCode, respTimeMillis);
    }
}
