package ru.yandex.market.logshatter.parser.lotalot;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.TskvSplitter;

/**
 * @author antontodua
 */
public class LotalotNginxAccessTskvLogParser implements LogParser {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final Pattern requestPattern = Pattern.compile("/api-v1/dealer/(?:app|internal)/(?<action>[\\w-/]+[\\w-]).*");

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("action", ColumnType.String),
        new Column("method", ColumnType.String),
        new Column("status", ColumnType.Int16),
        new Column("req_time", ColumnType.Int32),
        new Column("bytes_sent", ColumnType.Int32)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        TskvSplitter tskv = new TskvSplitter(line);

        String action = parseAction(tskv.getString("request"));
        if (action.isEmpty()) {
            return;
        }

        Date timestamp = dateFormat.parse(tskv.getString("timestamp"));
        Double requestTime = 1000 * tskv.getDouble("req_time");

        context.write(timestamp,
            context.getHost(),
            action,
            tskv.getString("method"),
            tskv.getInt("status"),
            requestTime.intValue(),
            tskv.getInt("bytes_sent"));
    }

    private static String parseAction(String request) {
        Matcher matcher = requestPattern.matcher(request);
        return matcher.matches()
            ? matcher.group("action")
                .replaceAll("/(?:[\\d]+|[\\w-]{21,})", "/id")
                .replace('/', '_')
            : "";
    }
}
