package ru.yandex.market.logshatter.parser.market_events;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.ParserException;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.TskvSplitter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;


/**
 * @author Dmitry Kornev <a href="mailto:tswr@yandex-team.ru"></a>
 * @date 2016-11-11
 */
public class AppMetricsLogParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        Arrays.asList("process", "key"),
        new Column("host", ColumnType.String),
        new Column("process", ColumnType.String),
        new Column("key", ColumnType.String),
        new Column("value", ColumnType.String)
    );

    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    @Override
    public void parse(String line, ParserContext context) throws ParserException {
        TskvSplitter tskv = new TskvSplitter(line);
        Date date;

        try {
            date = dateFormat.parse(tskv.getString("date"));
        } catch (ParseException e) {
            throw new ParserException("Error parsing date.", e);
        }

        String process = tskv.getString("process");

        Map<String, String> values = tskv.getValues();
        values.remove("date");
        values.remove("process");

        for (Map.Entry<String, String> entry : values.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            context.write(date, context.getHost(), process, key, value);
        }
    }

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }
}
