package ru.yandex.market.logshatter.parser.market_events;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.ParserException;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.TskvSplitter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;


/**
 * @author Dmitry Kornev <a href="mailto:tswr@yandex-team.ru"></a>
 * @date 2016-11-11
 */
public class MemoryReportByProcLogParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        Arrays.asList("process"),
        new Column("host", ColumnType.String),
        new Column("process", ColumnType.String),
        new Column("rss_bytes", ColumnType.Int64),
        new Column("pss_bytes", ColumnType.Int64),
        new Column("anon_bytes", ColumnType.Int64),
        new Column("uss_bytes", ColumnType.Int64),
        new Column("used_bytes", ColumnType.Int64)
    );

    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    @Override
    public void parse(String line, ParserContext context) throws ParserException {
        TskvSplitter tskv = new TskvSplitter(line);
        Date date;
        try {
            date = dateFormat.parse(tskv.getString("date"));
        } catch (ParseException e) {
            throw new ParserException("Error parsing date.", e);
        }
        String process = tskv.getString("process");
        Long rss = tskv.getOptionalLong("rss_bytes", -1L);
        Long pss = tskv.getOptionalLong("pss_bytes", -1L);
        Long anon = tskv.getOptionalLong("anon_bytes", -1L);
        Long uss = tskv.getOptionalLong("uss_bytes", -1L);
        Long used = tskv.getOptionalLong("used_bytes", -1L);

        context.write(date, context.getHost(), process, rss, pss, anon, uss, used);
    }

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }
}
