package ru.yandex.market.logshatter.parser.marketindexer;

import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.checkout.difflogs.CheckoutDiffLogParser;
import ru.yandex.market.logshatter.parser.nginx.NginxTskvLogEntry;

/**
 * @author Dmitry Senin <mailto:kairos@yandex-team.ru>
 *         date: 17/04/2018
 */
public class NginxTskvClickParser implements LogParser {

    @Override
    public TableDescription getTableDescription() {
        return CheckoutDiffLogParser.TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        NginxTskvLogEntry entry = new NginxTskvLogEntry(line, context.getPageMatcher());

        String pageId = entry.getPageId();
        if (!pageId.equals("api:checkouter-actualize") && !pageId.equals("api:checkout-actualize"))
            return;

        String eventType = pageId.contains("checkouter") ? "CHECKOUTER" : "CHECKOUT";
        context.write(
            entry.getDateTime(),
            context.getHost(),
            "NGINX",    // logType
            eventType,  // eventType
            "MARKET",   // context
            0,          // buyerPrice
            0,          // actualPrice
            0,          // buyerCount
            0,          // actualCount
            false,      // global
            0,          // shopId
            "UNKNOWN",  // rgb
            1          // warehouse
        );
    }

}
