package ru.yandex.market.logshatter.parser.marketout;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 23/03/15
 */
public class IndexerFeedAgeLogParser implements LogParser {

    private final DateFormat dateFormat = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss Z]");
    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("generation_id", ColumnType.String),
        new Column("feed_id", ColumnType.UInt32),
        new Column("offers_count", ColumnType.UInt32),
        new Column("start", ColumnType.DateTime),
        new Column("download", ColumnType.DateTime),
        new Column("publish", ColumnType.DateTime),
        new Column("status", ColumnType.String)
    );

    //[2015-03-23 19:14:19 +0300]	20150323_1643	397601	51892	[2015-03-23 15:15:13 +0300]	[2015-03-23 15:15:24 +0300]	ok
    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String splits[] = line.split("\t");
        Date publishDate = dateFormat.parse(splits[0]);
        String generationId = splits[1];
        Integer feedId = Integer.parseInt(splits[2]);
        Integer offersCount = Integer.parseInt(splits[3]);
        Date startDate = dateFormat.parse(splits[4]);
        String downloadDateString = splits[5];
        Date downloadDate;
        if (downloadDateString.equals("-")) {
            downloadDate = new Date(0);
        } else {
            downloadDate = dateFormat.parse(downloadDateString);
        }
        String status = splits[6];
        context.write(
            publishDate, context.getHost(), generationId, feedId, offersCount,
            startDate, downloadDate, publishDate, status
        );
    }


    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }
}
