package ru.yandex.market.logshatter.parser.marketout;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 23/03/15
 */
public class IndexerGenAgeLogParser implements LogParser {

    private static final int MINUTES_IN_HOUR = 60;

    private final DateFormat dateFormat = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss Z]");

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("index_age_minutes", ColumnType.UInt32),
        new Column("sc_session_age_minutes", ColumnType.UInt32)
    );

    //[2015-06-25 15:45:02 +0300]	50.5507034267	54.0507034267
    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String splits[] = line.split("\t");
        Date date = dateFormat.parse(splits[0]);
        Integer indexAgeMinutes = getMinutes(splits[1]);
        Integer scSessionAgeMinutes = getMinutes(splits[2]);

        context.write(date, context.getHost(), indexAgeMinutes, scSessionAgeMinutes);
    }

    private Integer getMinutes(String value) {
        return (int) (Double.parseDouble(value) * MINUTES_IN_HOUR);
    }

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }
}
