package ru.yandex.market.logshatter.parser.marketout;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 23/03/15
 */
public class IndexerNoCategoryOffersParser implements LogParser {

    private final DateFormat dateFormat = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss Z]");
    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("generation_id", ColumnType.String),
        new Column("total_offers", ColumnType.UInt64),
        new Column("nocateg_offers", ColumnType.UInt64),
        new Column("cpa_offers", ColumnType.UInt64),
        new Column("real_cpa_offers", ColumnType.UInt64)
    );

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String[] splits = line.split("\t");
        Date date = dateFormat.parse(splits[0]);
        String generationId = splits[1];
        Integer totalOffers = Integer.parseInt(splits[2]);
        Integer nocategOffers = Integer.parseInt(splits[3]);
        Integer cpaOffers = 0;
        Integer realCpaOffers = 0;
        if (splits.length >= 6) {
            cpaOffers = Integer.parseInt(splits[4]);
            realCpaOffers = Integer.parseInt(splits[5]);
        }
        context.write(date, context.getHost(), generationId, totalOffers, nocategOffers, cpaOffers, realCpaOffers);
    }

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }
}
