package ru.yandex.market.logshatter.parser.marketout;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author vlid
 * @date 01/12/17
 */
public class IndexerTopShopsLogParser implements LogParser {

    private final DateFormat dateFormat = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss Z]");

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("weight", ColumnType.Int64),
        new Column("download_seconds", ColumnType.UInt32),
        new Column("qparse_seconds", ColumnType.UInt32),
        new Column("parse_seconds", ColumnType.UInt32),
        new Column("full_minutes", ColumnType.UInt32)
    );

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String splits[] = line.split("\t");

        // Old format
        if (splits.length < 13) {
            return;
        }

        Date date = dateFormat.parse(splits[0]);
        long weight = Long.parseLong(splits[8]);
        Integer downloadSeconds = Integer.parseInt(splits[9]);
        Integer quickParseSeconds = Integer.parseInt(splits[10]);
        Integer parseSeconds = Integer.parseInt(splits[11]);
        Integer fullMinutes = Integer.parseInt(splits[12]);

        context.write(date, context.getHost(), weight, downloadSeconds, quickParseSeconds, parseSeconds, fullMinutes);
    }

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }
}
