package ru.yandex.market.logshatter.parser.marketout;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.clickhouse.ddl.engine.MergeTree;
import ru.yandex.market.logshatter.parser.ComplicatedLineParser;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 24/02/15
 * @deprecated use trace logs
 */
@Deprecated
public class MarketOutCorbaLogParser implements LogParser {

    public static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        Arrays.asList("corba"),
        new Column("host", ColumnType.String),
        new Column("method", ColumnType.String),
        new Column("http_code", ColumnType.UInt16),
        new Column("resptime_ms", ColumnType.Int32),
        new Column("corba", ColumnType.UInt8)
    );


    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private ComplicatedLineParser lineParser = new ComplicatedLineParser();

    private static final Integer HTTP_CODE = 200;

    /*
    Parse:
    PROFILE [2015-02-24 14:28:32 +0300] GetCards users-info 135256998,126246443 0
    PROFILE [2015-02-24 14:17:38 +0300] PutBestModelListBySettings 65
    Ignore:
    PROFILE [2015-02-24 14:17:38 +0300] /gurudaemon/GetCards 0
     */
    @Override
    public void parse(String line, ParserContext context) throws Exception {
        if (!line.startsWith("PROFILE")) {
            return;
        }
        lineParser.setLine(line);
        String dateString = lineParser.getStringSurroundedBy('[', ']', true);

        String method = lineParser.getStringSurroundedBySpace();
        if (method.startsWith("/")) {
            return; //Http запросы. Парсятся MarketOutNginxLogParser.
        }
        Date date = dateFormat.parse(dateString);
        Integer restTimeMillis = Integer.valueOf(line.substring(line.lastIndexOf(' ') + 1, line.length()));

        context.write(date, context.getHost(), method, HTTP_CODE, restTimeMillis, true);
    }

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }
}
