package ru.yandex.market.logshatter.parser.marketout;

import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.nginx.NginxTskvLogEntry;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 24/02/15
 */

public class MarketOutNginxLogParser implements LogParser {

    public void parse(String line, ParserContext context) throws Exception {
        NginxTskvLogEntry logEntry = new NginxTskvLogEntry(line, context.getPageMatcher());

        String method = ParseUtils.extractMethod(logEntry.getUrl());
        Integer hid = ParseUtils.extractIntegerParam(logEntry.getUrl(), "hid");
        if (method.equals("PopularModels")) {
            method = hid == 0 ? "PopularModelsMain" : "PopularModelsCategory";
        }

        context.write(
            logEntry.getDateTime(), context.getHost(), method,
            logEntry.getHttpCode(), logEntry.getRespTimeMillis(), false
        );
    }

    @Override
    public TableDescription getTableDescription() {
        return MarketOutCorbaLogParser.TABLE_DESCRIPTION;
    }
}
