package ru.yandex.market.logshatter.parser.marketout;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.KeyValueExtractor;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.TskvSplitter;

import java.util.Date;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 05/08/15
 */
public class MarketShowsLogParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("pp", ColumnType.Int32),
        new Column("pof", ColumnType.Int32),
        new Column("filter", ColumnType.Int32),
        new Column("state", ColumnType.Int32),
        new Column("geo_id", ColumnType.Int32),
        new Column("cpa", ColumnType.Int32),
        new Column("hyper_id", ColumnType.Int64),
        new Column("test_tag", ColumnType.String),
        new Column("ware_md5_sip_hash_64", ColumnType.UInt64),
        new Column("categ_id", ColumnType.Int32),
        new Column("url_type", ColumnType.Int32)
    );


    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        KeyValueExtractor extractor = createKeyValueExtractor(line);

        Date showTime = new Date(extractor.getLong("event_time") * 1000);

        Integer pp = extractor.getOptionalInt("pp", -1);
        Integer pof = extractor.getOptionalInt("pof", -1);
        Integer filter = extractor.getOptionalInt("filter", 0);
        Integer state = extractor.getOptionalInt("state", -1);
        Integer geoId = extractor.getOptionalInt("geo_id", -1);
        Integer cpa = extractor.getOptionalInt("cpa", -1);
        Long hyperId = extractor.getOptionalLong("hyper_id", -1L);
        String testTag = extractor.getOptionalString("test_tag", "");
        String wareMd5 = extractor.getOptionalString("ware_md5", "");

        Integer categoryId = extractor.getOptionalInt("category_id", -1);
        Integer urlType = extractor.getOptionalInt("url_type", -1);

        context.write(
            showTime, pp, pof, filter, state, geoId, cpa, hyperId,
            testTag, ParseUtils.sipHash64(wareMd5), categoryId, urlType
        );
    }

    protected KeyValueExtractor createKeyValueExtractor(String line) {
        return new TskvSplitter(line);
    }
}
