package ru.yandex.market.logshatter.parser.marketout;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.JsonLineParser;
import ru.yandex.market.logshatter.parser.KeyValueExtractor;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;

import java.util.Date;

/**
 * @author Anton Chugunov <a href="mailto:achugunov@yandex-team.ru"></a>
 */
public class PricesSnapshotStatsParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("market_color", ColumnType.String),
        new Column("offer_deleted", ColumnType.UInt32),
        new Column("price", ColumnType.UInt32),
        new Column("old_price", ColumnType.UInt32)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        KeyValueExtractor extractor = new JsonLineParser(line);

        Date timestamp = new Date(extractor.getLong("snapshot_timestamp") * 1000);

        String marketColor = getMarketColor(extractor.getInt("market_color"));
        Integer offerDeleted = extractor.getInt("offer_deleted");
        Integer price = extractor.getInt("price");
        Integer oldPrice = extractor.getInt("old_price");

        context.write(timestamp, context.getHost(), marketColor, offerDeleted, price, oldPrice);
    }

    private String getMarketColor(Integer color) {
        String marketColor;
        switch(color) {
            case 0: marketColor = "white";
                    break;
            case 1: marketColor = "blue";
                    break;
            case 2: marketColor = "red";
                    break;
            default:
                    marketColor = "unknown";
        }
        return marketColor;
    }
}
