package ru.yandex.market.logshatter.parser.marketout;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TskvSplitter;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Oleg Makovski <a href="mailto:omakovski@yandex-team.ru"></a>
 * @date 25/11/16
 */
public class ReportErrorLogParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("code", ColumnType.UInt32),
        new Column("category", ColumnType.String),
        new Column("data_file", ColumnType.String),
        new Column("url_hash", ColumnType.String),
        new Column("env", ColumnType.String),
        new Column("cluster", ColumnType.UInt8),
        new Column("message", ColumnType.String)
    );

    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        if (!line.startsWith("tskv")) {
            return;
        }
        TskvSplitter keyValues = new TskvSplitter(line);
        Date dateTime = ParseUtils.parseDateWithISO8601Fallback(keyValues.getString("timestamp"), dateFormat);
        // Error code is optional, 0 means unspecified error.
        Integer code = keyValues.getOptionalInt("code", 0);
        String category = keyValues.getString("category");
        String dataFile = keyValues.getOptionalString("data_file", "");
        String urlHash = keyValues.getOptionalString("url_hash", "");
        String env = keyValues.getOptionalString("env", "");
        Integer cluster = keyValues.getOptionalInt("cluster", 0);
        String message = keyValues.getOptionalString("message", "");
        context.write(dateTime, context.getHost(), code, category, dataFile, urlHash, env, cluster, message);
    }

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

}
