package ru.yandex.market.logshatter.parser.marketout;

import ru.yandex.market.logshatter.parser.ParserException;
import ru.yandex.market.logshatter.parser.nginx.NginxTskvLogEntry;
import ru.yandex.market.logshatter.url.PageMatcher;

/**
 * @author Oleg Makovski <a href="mailto:omakovski@yandex-team.ru"></a>
 * @date 04/05/17
 */
public class ReportNginxTskvLogEntry extends NginxTskvLogEntry {

    public ReportNginxTskvLogEntry(String line, PageMatcher pageMatcher) {
        super(line, pageMatcher);
    }

    public String getPlace() throws ParserException {
        return getStringUrlParam("place");
    }
    
    public String getEnv() throws ParserException {
        return getStringDeDash("env");
    }

    public int getCluster() throws ParserException {
        return values.getInt("cluster");
    }

    public String getBase() throws ParserException {
        return getStringUrlParam("base");
    }

    public Long getTouch() throws ParserException {
        return getLongUrlParam("touch", 0l);
    }

    public String getClient() throws ParserException {
        return getStringUrlParam("client");
    }
}
