package ru.yandex.market.logshatter.parser.marketout;

import com.google.common.base.Strings;
import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.ParserException;

/**
 * Описание формата : https://wiki.yandex-team.ru/Market/Development/Logs/shoplog/.
 *
 * @author kukabara
 */
public class ShopLogParser implements LogParser {
    private static final int SPLITS_COUNT = 19;

    public static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("pp", ColumnType.UInt32)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }


    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String[] splits = line.split("\t");
        if (splits.length < SPLITS_COUNT) {
            throw new ParserException("Split size must be more than " + SPLITS_COUNT);
        }

        int timestampSeconds = Integer.parseInt(splits[4]);
        String ppString = splits[19];
        if (Strings.isNullOrEmpty(ppString)) {
            return;
        }
        try {
            int pp = Integer.parseInt(ppString);
            if (pp < 0) {
                return;
            }

            context.write(timestampSeconds, pp);
        } catch (NumberFormatException e) {
            // skip it
        }
    }
}
