package ru.yandex.market.logshatter.parser.mbi;

import ru.yandex.market.logshatter.parser.LogParser;

public abstract class BasePartnerApiLogParser implements LogParser {

    protected Long getLong(String[] splits, int pos) {
        return parseLong(get(splits, pos));
    }

    protected Integer getInt(String[] splits, int pos) {
        return parseInt(get(splits, pos));
    }

    protected String get(String[] splits, int pos) {
        return get(splits, pos, null);
    }

    protected String get(String[] splits, int pos, String defaultVal) {
        return splits.length > pos ? splits[pos] : defaultVal;
    }

    protected boolean has(String[] splits, int pos) {
        return splits.length > pos;
    }

    protected Long parseLong(String string) {
        return isBlank(string) ? 0L : Long.valueOf(string);
    }

    protected Integer parseInt(String string) {
        return isBlank(string) ? 0 : Integer.valueOf(string);
    }

    protected boolean isBlank(String string) {
        return string == null || string.trim().isEmpty() || string.equals("-");
    }
}
