package ru.yandex.market.logshatter.parser.mbi;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TskvSplitter;

import java.util.Date;

/**
 * tskv	unixtime=1496125264	ip=2a02:6b8:0:2807:9d3f:1efb:9fbd:6c39	user_agent=Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 YaBrowser/16.7.0.3265 (beta) Safari/537.36	status=200	request_time=504	size=299161	resource=GET_V2/models/{}/offers	x_request_id=2ht053052c5ef28	x_market_req_id=1496125264392/ec0f9747b51201cb733e9ecefa32b6bd	geo_id=54	partner_id=1	statistics_requests=9	statistics_bytes=1145218	method=GET	uri=/v2/models/10495456/offers?secret=1&fields=all&geo_id=54
 */
public class ContentApiAccessLogParser implements LogParser {

    private static final String DEFAULT_VALUE = "-";

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("url", ColumnType.String),
        new Column("partnerId", ColumnType.String),
        new Column("duration", ColumnType.UInt32),
        new Column("responseCode", ColumnType.UInt16),
        new Column("requestId", ColumnType.String),
        new Column("resource", ColumnType.String),
        new Column("clid", ColumnType.String),
        new Column("ip", ColumnType.String),
        new Column("uuid", ColumnType.String), // уникальный идентификатор мобильного устройства
        new Column("platform", ColumnType.String), // платформа мобильного приложения: ios|android
        new Column("deviceType", ColumnType.String), // планшет или смартфон
        new Column("appVersion", ColumnType.String),
        new Column("marketReqId", ColumnType.String),
        new Column("signature", ColumnType.String),
        new Column("signIsValid", ColumnType.UInt8),
        new Column("exception", ColumnType.String)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        TskvSplitter splitter = new TskvSplitter(line);
        if (splitter.getValues().size() < 6) {
            return;
        }
        Date date = new Date(splitter.getLong("unixtime") * 1000);

        String ip = splitter.getString("ip");
        String partnerId = splitter.getOptionalString("partner_id", DEFAULT_VALUE);
        String url = splitter.getString("uri");
        int duration = splitter.getInt("request_time");
        int responseCode = splitter.getInt("status");

        String requestId = splitter.getOptionalString("x_request_id", DEFAULT_VALUE);
        String resource = splitter.getOptionalString("resource", DEFAULT_VALUE).replace("{}", "id");
        String clid = splitter.getOptionalString("clid", DEFAULT_VALUE);
        String uuid = splitter.getOptionalString("uuid", DEFAULT_VALUE);
        String platform = splitter.getOptionalString("platform", DEFAULT_VALUE);
        String deviceType = splitter.getOptionalString("device_type", DEFAULT_VALUE);
        String appVersion = splitter.getOptionalString("app_version", DEFAULT_VALUE);
        String marketReqId = splitter.getOptionalString("x_market_req_id", DEFAULT_VALUE);
        String signature = splitter.getOptionalString("signature", DEFAULT_VALUE);
        boolean signIsValid = "ok".equalsIgnoreCase(splitter.getOptionalString("signature_status", DEFAULT_VALUE));
        String exception = splitter.getOptionalString("exception", DEFAULT_VALUE);

        context.write(date, context.getHost(), url, partnerId, duration, responseCode, requestId, resource, clid, ip,
            uuid, platform, deviceType, appVersion, marketReqId, signature, signIsValid, exception);
    }
}
