package ru.yandex.market.logshatter.parser.mbi;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;

/**
 * Парсит записи в логе, относящиеся к работе кэшей
 * <p>
 * [2016-10-07 08:36:52,294] INFO  [main]  #cache, LOAD_CACHE_END, NAME: georegions.xml, SOURCE: /home/apershukov/var/cache/georegions.xml, DURATION: 1232, #tm2k
 * <p>
 * Created by apershukov on 07.10.16.
 */
public class ContentApiCacheLogParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("cache", ColumnType.String),
        new Column("action", ColumnType.String),
        new Column("error", ColumnType.UInt8),
        new Column("duration", ColumnType.UInt32)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        if (!line.contains("#cache")) {
            return;
        }

        String[] parts = line.split("\\s++");

        String mark = nextTo("#cache,", parts);
        if (mark.endsWith("_START,")) {
            return;
        }

        context.write(ContentApiHelper.parseDate(line),
            context.getHost(),
            parseCacheName(parts),
            parseAction(mark),
            ContentApiHelper.withError(parts),
            ContentApiHelper.duration(parts)
        );
    }

    private String parseAction(String mark) {
        return mark.substring(0, mark.lastIndexOf('_'));
    }

    private String parseCacheName(String[] parts) {
        return nextTo("NAME:", parts).replace(",", "");
    }

    private String nextTo(String str, String[] parts) {
        for (int i = 0, n = parts.length - 1; i < n; ++i) {
            if (parts[i].equals(str)) {
                return parts[i + 1];
            }
        }
        throw new IllegalStateException("Part" + str + " not found");
    }
}
