package ru.yandex.market.logshatter.parser.mbi;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.text.ParseException;
import java.util.Date;

/**
 * [2015-03-10 14:30:58,644] INFO  [Service Thread]  #gc, NAME: parnew, ACTION: endOfMinorGC, CAUSE: allocationFailure, ID: 2614, DURATION: 11, PAR-SURVIVOR-SPACE: 6217K->8600K, CODE-CACHE: 53M->53M, COMPRESSED-CLASS-SPACE: 6521K->6521K, METASPACE: 56M->56M, PAR-EDEN-SPACE: 273M->0, CMS-OLD-GEN: 537M->537M
 */
public class ContentApiGcLogParser implements LogParser {

    public static final int MIN_COLUMN_NUMBER = 6;
    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("type", ColumnType.String),
        new Column("duration", ColumnType.UInt16),
        new Column("memory", ColumnType.UInt32)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        if (line.charAt(0) != '[') {
            return;
        }
        String[] parts = line.split("\\s++");
        if (parts.length < MIN_COLUMN_NUMBER) {
            return;
        }

        Date date;
        try {
            date = ContentApiHelper.parseDate(line);
        } catch (ParseException e) {
            return;
        }
        String marker = parts[5];
        switch (marker) {
            case "#gc,":
                String geAction = ContentApiHelper.getValue(parts, "ACTION:");
                int memory = ContentApiHelper.getGcMemory(parts);
                write(context, date, geAction, ContentApiHelper.duration(parts), memory);
                return;

            default:
                return;
        }
    }

    private void write(ParserContext context,
                       Date date,
                       String type,
                       int duration,
                       int value) {
        context.write(date, context.getHost(), type.replace(",", ""), duration, value);
    }
}
