package ru.yandex.market.logshatter.parser.mbi;

import ru.yandex.market.logshatter.parser.ComplicatedLineParser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by tesseract on 11.03.15.
 */
public class ContentApiHelper {

    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss,S";

    private static final ThreadLocal<SimpleDateFormat> parsers = new ThreadLocal<SimpleDateFormat>() {
        @Override
        protected SimpleDateFormat initialValue() {
            return dateFormat();
        }
    };

    public static SimpleDateFormat dateFormat() {
        return new SimpleDateFormat(DATE_FORMAT);
    }

    public static int duration(String[] parts) {
        String rawDuration = getValue(parts, "DURATION:");
        return null == rawDuration ? 0 : Integer.parseInt(rawDuration.replace(",", ""));
    }

    public static int getGcMemory(String[] parts) {
        String rawMemory = getValue(parts, "CMS-OLD-GEN:");
        if (null == rawMemory) {
            rawMemory = getValue(parts, "OLD-GEN:");
        }
        // "537M->200M"
        rawMemory = rawMemory.split("->")[1];
        int cutCharsNumber = rawMemory.endsWith(",") ? 2 : 1;
        int memory = Integer.parseInt(rawMemory.substring(0, rawMemory.length() - cutCharsNumber));
        if (rawMemory.endsWith("M") || rawMemory.endsWith("M,")) {
            return memory << 10;
        }
        if (rawMemory.endsWith("G") || rawMemory.endsWith("G,")) {
            return memory << 20;
        }
        return memory;
    }

    public static String getValue(String[] parts, String key) {
        for (int i = 0; i < parts.length; ++i) {
            if (key.equals(parts[i]) && ++i < parts.length) {
                return parts[i];
            }
        }
        return null;
    }

    public static Date parseDate(String line) throws ParseException {
        ComplicatedLineParser lineParser = new ComplicatedLineParser();
        lineParser.setLine(line);
        return parsers.get().parse(lineParser.getStringSurroundedBy('[', ']', true));
    }

    public static boolean withError(String[] parts) {
        return null != getValue(parts, "ERROR:");
    }

}
