package ru.yandex.market.logshatter.parser.mbi;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;

import java.text.ParseException;
import java.util.Date;

/**
 * [2015-03-10 13:06:43,514] INFO  [defaultEventExecutor-3-1] 05h14c023e9482 #http_request_end, Report, 9102:3, URL: http://warehouse:17051/yandsearch?place=mainreport&pp=38&pg=38&ip=85.26.165.209&base=mobile.market.yandex.net/market/content/v1/call&phone=1&text=%D1%87%D0%B5%D1%85%D0%BB%D1%8B%20%D0%B4%D0%BB%D1%8F%20%D0%BC%D0%BE%D0%B1%D0%B8%D0%BB%D1%8C%D0%BD%D1%8B%D1%85%20%D1%82%D0%B5%D0%BB%D0%B5%D1%84%D0%BE%D0%BD%D0%BE%D0%B2%20%D0%BB%D0%B5%D0%BD%D0%BE%D0%B2%D0%BE%20a369i&rids=20616&page=2&numdoc=10&currency=RUR&offer-shipping=pickup,store,delivery,model&how&geo-location=48.559681,46.414524, RESPONSE_CODE: -, ERROR: io.netty.channel.ConnectTimeoutException, ERROR_MSG: connection timed out: warehouse/2a02:6b8:0:3400:0:0:2:23:17051, DURATION: 51, #tm100
 */
public class ContentApiLogParser implements LogParser {

    public static final int MIN_COLUMN_NUMBER = 6;
    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("requestId", ColumnType.String),
        new Column("type", ColumnType.String),
        new Column("service", ColumnType.String),
        new Column("duration", ColumnType.UInt32),
        new Column("error", ColumnType.UInt8),
        new Column("retry", ColumnType.UInt8)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        if (line.charAt(0) != '[') {
            return;
        }
        String[] parts = line.split("\\s++");
        if (parts.length < MIN_COLUMN_NUMBER) {
            return;
        }

        Date date;
        try {
            date = ContentApiHelper.parseDate(line);
        } catch (ParseException | IllegalStateException e) {
            return;
        }
        String requestId = parts[4];
        String marker = parts[5];
        switch (marker) {
            case "#http_request_end,":
                String httpService = parts[6];
                write(context,
                    date,
                    requestId,
                    "externals",
                    httpService,
                    ContentApiHelper.duration(parts),
                    ContentApiHelper.withError(parts),
                    isHttpRetry(parts));
                return;

            case "#profiler,":
                String method = parts[7];
                write(context,
                    date,
                    requestId,
                    "profiler",
                    method,
                    ContentApiHelper.duration(parts),
                    ContentApiHelper.withError(parts),
                    false);
                return;

            default:
                return;
        }
    }

    private boolean isHttpRetry(String[] parts) {
        return !parts[7].endsWith(":1,");
    }

    private void write(ParserContext context,
                       Date date,
                       String requestId,
                       String type,
                       String service,
                       int duration,
                       boolean error,
                       boolean retry) {
        context.write(date,
            context.getHost(),
            requestId,
            type,
            service.replace(",", ""),
            duration,
            error,
            retry);
    }
}
