package ru.yandex.market.logshatter.parser.mbi;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Парсит записи в логе, относящиеся к wаrning'ам
 * <p>
 * [2016-12-12 16:23:00,667] WARN  [requestThreadPool-79] ida1212f333481f Type: UNSUPPORTED_REDIRECT, Message: REPORT_REDIRECT_TYPE: Test type
 * <p>
 * Created by apershukov on 12.12.16.
 */
public class ContentApiWarningLogParser implements LogParser {

    private static final Pattern PATTERN = Pattern.compile("^\\[.+\\] WARN  \\[.+\\] ([\\w-]*) Type: (\\w+), Message: (.+)$");

    @Override
    public TableDescription getTableDescription() {
        return TableDescription.createDefault(
            new Column("host", ColumnType.String),
            new Column("requestId", ColumnType.String),
            new Column("type", ColumnType.String),
            new Column("message", ColumnType.String)
        );
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        Matcher matcher = PATTERN.matcher(line);
        if (!matcher.matches()) {
            return;
        }

        context.write(ContentApiHelper.parseDate(line),
            context.getHost(),
            matcher.group(1),
            matcher.group(2),
            matcher.group(3));
    }
}
