package ru.yandex.market.logshatter.parser.mbi;

import com.google.common.primitives.Ints;
import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.util.Date;

import static ru.yandex.market.logshatter.parser.mbi.ContentApiHelper.parseDate;

/**
 * MBI-17192: пытаемся вычислить хитрэйтио мемкеша.
 */
public class HitRatioProfilerLogParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("url", ColumnType.String),
        new Column("requestId", ColumnType.String),
        new Column("missCount", ColumnType.UInt32),
        new Column("callCount", ColumnType.UInt32)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    // [2016-06-10 12:11:38,332] DEBUG [1340744662@RequestThread-0] RequestCounts /get-cpa-shops#959493880 counts: 4 misses: 2

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String[] parts = line.split("\\s");
        if (parts.length < 10) {
            return;
        }

        String type = parts[4];
        if (!"RequestCounts".equals(type)) {
            return;
        }

        String requestId = parts[5];
        String url = requestId.split("#")[0];
        Integer callCount = Ints.tryParse(parts[7]);
        Integer missCount = Ints.tryParse(parts[9]);

        Date date = parseDate(parts[0] + " " + parts[1]);
        context.write(date, context.getHost(), url, requestId, callCount, missCount);
    }
}
