package ru.yandex.market.logshatter.parser.mbi;

import com.google.common.base.MoreObjects;
import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.clickhouse.ddl.engine.MergeTree;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.nginx.NginxTskvLogEntry;
import ru.yandex.market.logshatter.url.Page;
import ru.yandex.market.logshatter.url.PageMatcher;

import java.util.Arrays;

/**
 * Log parser для access-tskv логов бекенда партнёрского интерфейса.
 *
 * @author stani on 06.03.18.
 */
public class MbiPartnerNginxTskvLogParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        Arrays.asList("vhost", "http_code"),
        new Column("host", ColumnType.String),
        new Column("vhost", ColumnType.String),
        new Column("url", ColumnType.String),
        new Column("http_method", ColumnType.String),
        new Column("method", ColumnType.String),
        new Column("http_code", ColumnType.UInt16),
        new Column("resptime_ms", ColumnType.Int32),
        new Column("client_ip", ColumnType.String),
        new Column("test_id", ColumnType.ArrayInt32),
        new Column("client_reqtime_ms", ColumnType.Int32),
        new Column("bytes_sent", ColumnType.Int32),
        new Column("req_id", ColumnType.String),
        new Column("uid", ColumnType.Int64),
        new Column("euid", ColumnType.Int64),
        new Column("campaign_id", ColumnType.Int64)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        PageMatcher pageMatcher = context.getPageMatcher();
        NginxTskvLogEntry entry = new NginxTskvLogEntry(line, pageMatcher);

        Page page = pageMatcher.matchUrl(entry.getVHost(), entry.getHttpMethod(), entry.getUrl());
        page = MoreObjects.firstNonNull(page, Page.EMPTY);

        context.write(
            entry.getDateTime(), context.getHost(), entry.getVHost(), entry.getUrl(),
            entry.getHttpMethod(), page.getId(), entry.getHttpCode(), entry.getRespTimeMillis(),
            entry.getClientIp(), entry.getTestIds(), entry.getClientReqTimeMillis(),
            entry.getBytesSent(), entry.getReqId(), entry.getLongUrlParam("_user_id", -1L),
            entry.getLongUrlParam("euid", -1L), entry.getLongUrlParam("id", -1L)
        );
    }
}
