package ru.yandex.market.logshatter.parser.mbi;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.clickhouse.ddl.engine.MergeTree;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

/**
 * Парсер для логов контентного API
 * Пишутся - https://svn.yandex-team.ru/market/market/trunk/api/partner/src/java/ru/yandex/market/api/partner/log/impl/PartnerApiErrorLog.java
 */
public class PartnerApiErrorLogParser extends BasePartnerApiLogParser {
    private static final int DATE = 0;
    private static final int TYPE = 1;
    private static final int EXCEPTION = 2;
    private static final int DESCRIPTION = 3;
    private static final int TRACE_ID = 4;

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
            Arrays.asList("type"),
            new Column("host", ColumnType.String),
            new Column("type", ColumnType.String),
            new Column("exception", ColumnType.String),
            new Column("description", ColumnType.String),
            new Column("trace_id", ColumnType.String)
    );


    private final DateFormat dateFormat = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss Z]");

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    /**
     * [2015-03-20 18:51:19 +0300]     REPORT  IO
     * [2015-03-20 18:51:36 +0300]     REPORT  sdlkjfgdsj oslg e hge jgsdhg ...
     * [2015-03-20 19:02:23 +0300]     UNKNOWN Required long parameter 'regi...
     */
    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String[] splits = line.split("\t");
        if (!has(splits, TYPE)) {
            return;
        }
        Date date = getDate(splits);
        String type = get(splits, TYPE);
        String exception = get(splits, EXCEPTION);
        String description = get(splits, DESCRIPTION);
        String traceId = get(splits, TRACE_ID, "0/-");
        context.write(date, context.getHost(), type, exception, asGraphiteKey(description), traceId);
    }

    /**
     * Приводит строку к виду, в котором она может использоваться в названии метрики в graphite.
     */
    private String asGraphiteKey(String description) {
        return description == null ? "" : description.replaceAll("[^\\w\\d]]", "_");
    }

    private Date getDate(String[] splits) throws ParseException {
        String dateStr = get(splits, DATE);
        return dateFormat.parse(dateStr);
    }

}
