package ru.yandex.market.logshatter.parser.mbo;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author amaslak
 */
public class MboGwtLogParser implements LogParser {

    public static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss,S";

    private final SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_PATTERN);

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("service", ColumnType.String),
        new Column("method", ColumnType.String),
        new Column("exec_id", ColumnType.String),
        new Column("exec_time_ms", ColumnType.Int32)
    );

    private static final Pattern LOG_METHOD_PATTERN = Pattern.compile(
        "(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3})" +
            " INFO\\s+\\[(\\w+)" +
            " (\\w+)\\.(\\w+)-[0-9a-f\\d]+-(\\d+)\\]" +
            " Processing time is (\\d+) ms"
    );

    @Override
    @SuppressWarnings("checkstyle:magicnumber")
    public void parse(String line, ParserContext context) throws Exception {
        Matcher matcher = LOG_METHOD_PATTERN.matcher(line);
        if (!matcher.matches()) {
            return;
        }

        Date date = dateFormat.parse(matcher.group(1));
        String service = matcher.group(3);
        String method = matcher.group(4);
        String execId = matcher.group(5);
        int execTimeMillis = Integer.parseInt(matcher.group(6));

        context.write(date, context.getHost(), service, method, execId, execTimeMillis);
    }

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

}
