package ru.yandex.market.logshatter.parser.mbo;

import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.ir.ScAgeParser;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 09/03/16
 */
public class MboTmsClusterAgeLogParser implements LogParser {

    public final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    @Override
    public TableDescription getTableDescription() {
        return ScAgeParser.TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String[] splits = line.split("\t");
        Date date = dateFormat.parse(splits[0]);
        Integer category = Integer.valueOf(splits[1]);
        String metric = splits[2];
        Integer timeHours = Integer.valueOf(splits[3]) * 24;
        Integer count = Integer.valueOf(splits[4]);

        context.write(date, metric, context.getHost(), category, timeHours, count);
    }
}
