package ru.yandex.market.logshatter.parser.mstat;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Данные о коэффициентах исполняемости и качества по умолчанию для категории
 *
 * @author Alexander Novikov <a href="mailto:hronos@yandex-team.ru"></a>
 * @date 16/05/17
 */
public class DefaultCategoryAverageQualityRatioLogParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("category_id", ColumnType.Int64),
        new Column("average_fulfilment_ratio", ColumnType.Float64),
        new Column("average_quality_ratio", ColumnType.Float64),
        new Column("average_fulfilment_bonus", ColumnType.Int32),
        new Column("average_quality_bonus", ColumnType.Int32)
    );

    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    /*
        2017-04-30 16:34:10	12802914	0.8966	0.8531	80	85
     */

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String[] paramsList = line.split("\t");

        int index = 0;

        Date calculationTime = dateFormat.parse(paramsList[index++]);
        Long categoryId = ParseUtils.parseLong(paramsList[index++], -1L);
        Double averageFulfilmentRatio = ParseUtils.parseDouble(paramsList[index++], Double.NaN);
        Double averageQualityRatio = ParseUtils.parseDouble(paramsList[index++], Double.NaN);
        Integer averageFulfilmentBonus = ParseUtils.parseInt(paramsList[index++], -1);
        Integer averageQualityBonus = ParseUtils.parseInt(paramsList[index], -1);

        context.write(
            calculationTime,
            categoryId,
            averageFulfilmentRatio,
            averageQualityRatio,
            averageFulfilmentBonus,
            averageQualityBonus
        );
    }


}
