package ru.yandex.market.logshatter.parser.mstat;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Данные о коэффициентах качества и исполняемости + сопутствующие значения в разрезе магазин-категория
 *
 * @author Alexander Novikov <a href="mailto:hronos@yandex-team.ru"></a>
 * @date 16/05/17
 */
public class ShopCatQualityRatioLogParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
            new Column("shop_id", ColumnType.Int64),
            new Column("category_id", ColumnType.Int64),
            new Column("raw_sum_created", ColumnType.Int32),
            new Column("raw_sum_cancelled", ColumnType.Int32),
            new Column("final_sum_created", ColumnType.Int32),
            new Column("final_sum_cancelled", ColumnType.Int32),
            new Column("offers_count", ColumnType.Int32),
            new Column("cpa_offers_count", ColumnType.Int32),
            new Column("average_fulfilment_ratio", ColumnType.Float64),
            new Column("average_quality_ratio", ColumnType.Float64),
            new Column("average_fulfilment_bonus", ColumnType.Int32),
            new Column("average_quality_bonus", ColumnType.Int32),
            new Column("fulfilment_ratio_type", ColumnType.Int8),
            new Column("economy", ColumnType.Int64)
    );

    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    /*
        2017-04-30 16:34:10	234	12802914	34	5	31	2	8	5	0.9197	0.8278	91	82	1	0
     */

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String[] paramsList = line.split("\t");

        int index = 0;

        Date calculationTime = dateFormat.parse(paramsList[index++]);
        Long shopId = ParseUtils.parseLong(paramsList[index++], -1L);
        Long categoryId = ParseUtils.parseLong(paramsList[index++], -1L);

        Integer rawSumCreated = ParseUtils.parseInt(paramsList[index++], -1);
        Integer rawSumCancelled = ParseUtils.parseInt(paramsList[index++], -1);
        Integer finalSumCreated = ParseUtils.parseInt(paramsList[index++], -1);
        Integer finalSumCancelled = ParseUtils.parseInt(paramsList[index++], -1);

        Integer offersCount = ParseUtils.parseInt(paramsList[index++], -1);
        Integer cpaOffersCount = ParseUtils.parseInt(paramsList[index++], -1);

        Double averageFulfilmentRatio = ParseUtils.parseDouble(paramsList[index++], Double.NaN);
        Double averageQualityRatio = ParseUtils.parseDouble(paramsList[index++], Double.NaN);
        Integer averageFulfilmentBonus = ParseUtils.parseInt(paramsList[index++], -1);
        Integer averageQualityBonus = ParseUtils.parseInt(paramsList[index++], -1);

        Integer fulfilmentRatioType = ParseUtils.parseInt(paramsList[index++], -1);
        Long economy = ParseUtils.parseLong(paramsList[index], 0L);

        context.write(
                calculationTime, shopId, categoryId, rawSumCreated, rawSumCancelled, finalSumCreated, finalSumCancelled, offersCount, cpaOffersCount,
                averageFulfilmentRatio, averageQualityRatio, averageFulfilmentBonus, averageQualityBonus, fulfilmentRatioType, economy
        );
    }


}
