package ru.yandex.market.logshatter.parser.mstat;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Данные о коэффициентах качества и исполняемости + сопутствующие значения в разрезе по магазинам
 *
 * @author Alexander Novikov <a href="mailto:hronos@yandex-team.ru"></a>
 * @date 16/05/17
 */
public class ShopQualityRatioLogParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
            new Column("shop_id", ColumnType.Int64),
            new Column("raw_sum_created", ColumnType.Int32),
            new Column("raw_sum_cancelled", ColumnType.Int32),
            new Column("final_sum_created", ColumnType.Int32),
            new Column("final_sum_cancelled", ColumnType.Int32),
            new Column("average_weighted_fulfilment_ratio", ColumnType.Float64),
            new Column("average_weighted_quality_ratio", ColumnType.Float64),
            new Column("average_weighted_fulfilment_bonus", ColumnType.Int32),
            new Column("average_weighted_quality_bonus", ColumnType.Int32),
            new Column("sum_economy", ColumnType.Int64),
            new Column("prepay_enabled", ColumnType.UInt8)
    );

    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    /*
        2017-04-30 16:34:10	234	4968	1476	4448	956	0.7763	0.6986	77	69	0	false
     */

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String[] paramsList = line.split("\t");

        int index = 0;

        Date calculationTime = dateFormat.parse(paramsList[index++]);
        Long shopId = ParseUtils.parseLong(paramsList[index++], -1L);
        Integer rawSumCreated = ParseUtils.parseInt(paramsList[index++], -1);
        Integer rawSumCancelled = ParseUtils.parseInt(paramsList[index++], -1);
        Integer finalSumCreated = ParseUtils.parseInt(paramsList[index++], -1);
        Integer finalSumCancelled = ParseUtils.parseInt(paramsList[index++], -1);
        Double averageWeightedFulfilmentRatio = ParseUtils.parseDouble(paramsList[index++], Double.NaN);
        Double averageWeightedQualityRatio = ParseUtils.parseDouble(paramsList[index++], Double.NaN);
        Integer averageWeightedFulfilmentBonus = ParseUtils.parseInt(paramsList[index++], -1);
        Integer averageWeightedQualityBonus = ParseUtils.parseInt(paramsList[index++], -1);
        Long sumEconomy = ParseUtils.parseLong(paramsList[index++], -1L);
        Integer prepayEnabled = ParseUtils.parseBoolean(paramsList[index], 0);

        context.write(
                calculationTime, shopId, rawSumCreated, rawSumCancelled, finalSumCreated, finalSumCancelled, averageWeightedFulfilmentRatio,
                averageWeightedQualityRatio, averageWeightedFulfilmentBonus, averageWeightedQualityBonus, sumEconomy, prepayEnabled
        );
    }


}
