package ru.yandex.market.logshatter.parser.nginx;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickhouse.ddl.enums.EnumColumnType;
import ru.yandex.market.logshatter.parser.EnvironmentMapper;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.trace.Environment;

import java.util.Arrays;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 13/09/16
 */
public class NginxTskvLogParser implements LogParser {

    public static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        Arrays.asList("vhost", "http_code"),
        new Column("host", ColumnType.String),
        new Column("vhost", ColumnType.String),
        new Column("url", ColumnType.String),
        new Column("http_method", ColumnType.String),
        new Column("http_code", ColumnType.UInt16),
        new Column("resptime_ms", ColumnType.Int32),
        new Column("dynamic", ColumnType.UInt8),
        new Column("page_id", ColumnType.String),
        new Column("page_type", ColumnType.String),
        new Column("service", ColumnType.String),
        new Column("client_ip", ColumnType.String),
        new Column("user_agent", ColumnType.String),
        new Column("test_id", ColumnType.ArrayInt32), // список идентификаторов экспериментов
        new Column("yandex_uid", ColumnType.String),
        new Column("yandex_login", ColumnType.String),
        new Column("client_reqtime_ms", ColumnType.Int32),
        new Column("ssl_handshake_time_ms", ColumnType.Int32),
        new Column("bytes_sent", ColumnType.Int32),
        new Column("req_id", ColumnType.String),
        new Column("referer", ColumnType.String),
        new Column("tvm", ColumnType.String),
        new Column("yandex_market", ColumnType.String),
        new Column("yandex_gid", ColumnType.Int32),
        new Column("yp", ColumnType.String),
        new Column("ys", ColumnType.String),
        new Column("euid", ColumnType.Int64),
        new Column("invalid_cookie_names", ColumnType.ArrayString),
        new Column("invalid_cookie_values", ColumnType.ArrayString),
        new Column("environment", EnumColumnType.enum8(Environment.class), "'UNKNOWN'"),
        new Column("request_tags", ColumnType.ArrayString)
    );

    private EnvironmentMapper environmentMapper = new EnvironmentMapper(EnvironmentMapper.LOGBROKER_PROTOCOL_PREFIX);

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        NginxTskvLogEntry entry = new NginxTskvLogEntry(line, context.getPageMatcher());
        context.write(
            entry.getDateTime(), context.getHost(), entry.getVHost(), entry.getUrl(),
            entry.getHttpMethod(), entry.getHttpCode(), entry.getRespTimeMillis(),
            entry.isDynamic(), entry.getPageId(), entry.getPageType(), entry.getService(),
            entry.getClientIp(), entry.getUserAgent(), entry.getTestIds(),
            entry.getYandexUid(), entry.getYandexLogin(),
            entry.getClientReqTimeMillis(), entry.getSslHandshakeTimeMillis(), entry.getBytesSent(),
            entry.getMarkerRequestId(), entry.getReferer(), entry.getTvm().name(),
            entry.getYandexMarketCookie(), entry.getYandexGid(),
            entry.getYandexPortalPermanentMetaCookie(), entry.getYandexPortalSessionMetaCookie(),
            entry.getEffectiveUserId(),
            entry.getInvalidCookieNames(), entry.getInvalidCookieValues(), environmentMapper.getEnvironment(context),
            entry.getRequestTags()
        );
    }
}
