package ru.yandex.market.logshatter.parser.pers;

import com.google.common.base.MoreObjects;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.common.CommonRestLogParser;
import ru.yandex.market.logshatter.url.Page;

public class PersGradeLogParser extends CommonRestLogParser {

    protected String getHost() {
        return "pers-grade.http.yandex.net";
    }

    @Override
    protected void write(ParserContext context, int timestampSeconds, String httpMethod, String url,
                         int statusCode, int executionTimeMillis, long uid, boolean isDynamic) {
        Page matchedPage = context.getPageMatcher().matchUrl(getHost(), httpMethod, url);
        String pageId = MoreObjects.firstNonNull(matchedPage, Page.EMPTY).getId();
        context.write(
                timestampSeconds, context.getHost(), url, httpMethod, statusCode, executionTimeMillis,
                pageId, uid, isDynamic
        );
    }

}
