package ru.yandex.market.logshatter.parser.recommender;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;

import java.util.Arrays;
import java.util.HashSet;

/**
 * @author Andrey Sboev <a href="mailto:yacoder@yandex-team.ru"></a>
 * @date 08/02/19
 */
public class RecommenderNginxLogParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("upstream_resp_time_ms", ColumnType.Int32),
        new Column("req_time_ms", ColumnType.Int32),
        new Column("upstream_header_time_ms", ColumnType.Int32),
        new Column("action", ColumnType.String),
        new Column("http_code", ColumnType.UInt16),
        new Column("market_req_id", ColumnType.String)
    );


    private static final HashSet<String> SERVICE_ACTIONS = new HashSet<>(Arrays.asList(
        "close",
        "help",
        "info",
        "monitoring",
        "open",
        "ping",
        "reopen_log",
        "stat"
    ));

    public void parse(String line, ParserContext context) throws Exception {
        RecommenderNginxTskvLogEntry logEntry = new RecommenderNginxTskvLogEntry(line, context.getPageMatcher());
        final String action = logEntry.getAction();
        if (SERVICE_ACTIONS.contains(action)) {
            return;
        }
        context.write(
            logEntry.getDateTime(),
            context.getHost(),
            logEntry.getRespTimeMillis(),
            logEntry.getClientReqTimeMillis(),
            logEntry.getHeaderTimeMillis(),
            action,
            logEntry.getHttpCode(),
            logEntry.getMarkerRequestId()
        );
    }

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }
}
