package ru.yandex.market.logshatter.parser.recommender;

import ru.yandex.market.logshatter.parser.ParserException;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.nginx.NginxTskvLogEntry;
import ru.yandex.market.logshatter.url.PageMatcher;

/**
 * @author Andrey Sboev <a href="mailto:yacoder@yandex-team.ru"></a>
 * @date 08/02/19
 */
public class RecommenderNginxTskvLogEntry extends NginxTskvLogEntry {

    public RecommenderNginxTskvLogEntry(String line, PageMatcher pageMatcher) {
        super(line, pageMatcher);
    }

    public String getAction() throws ParserException {
        final String path = ParseUtils.cutQueryStringAndFragment(getUrl());
        if (path.isEmpty()) {
            return "";
        }
        return path.substring(1);
    }
}
