package ru.yandex.market.logshatter.parser.startrek;

import com.google.gson.Gson;
import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.reader.startrek.StarTrekHistoryEvent;
import ru.yandex.market.logshatter.reader.startrek.StarTrekLine;

import java.util.Date;

/**
 * @author Vlad Vinogradov <a href="mailto:vladvin@yandex-team.ru"></a> on 14.12.16
 */
public class StarTrekHistoryParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = StarTrekBaseInfo.buildTableDescription(
        new Column("newStatus", ColumnType.String),
        new Column("prevStatus", ColumnType.String),
        new Column("prevStatusDateTime", ColumnType.DateTime)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        final StarTrekLine starTrekLine = new Gson().fromJson(line, StarTrekLine.class);

        String prevStatus = "";
        long prevStatusDateMillis = 0;

        for (StarTrekHistoryEvent historyEvent : starTrekLine.getHistory()) {
            boolean isNewEvent = historyEvent.getEventMillis() > starTrekLine.getLastParsingMillis();
            boolean isStatusChange = StarTrekBaseInfo.STATUS_EVENT_KEY.equals(historyEvent.getEventKey());

            final String newStatus = historyEvent.getEventValue();
            if (isStatusChange)
                if (isNewEvent) {

                    final Object[] fields = StarTrekBaseInfo.buildLineInfo(
                        starTrekLine,
                        newStatus,
                        prevStatus,
                        new Date(prevStatusDateMillis));

                    context.write(new Date(historyEvent.getEventMillis()), fields);
                }

            prevStatus = newStatus;
            prevStatusDateMillis = historyEvent.getEventMillis();
        }

    }
}
