package ru.yandex.market.logshatter.parser.trace;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickhouse.ddl.enums.EnumColumnType;
import ru.yandex.market.logshatter.parser.EnvironmentMapper;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;

import java.util.Arrays;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 13/09/16
 */
public abstract class AbstractTraceLogParser implements LogParser {

    protected static final Object[] EMPTY_ARRAY = new Object[]{};

    public static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        Arrays.asList("id_hash"),
        new Column("id_ms", ColumnType.UInt64),
        new Column("id_hash", ColumnType.String),
        new Column("id_seq", ColumnType.ArrayUInt32),
        new Column("start_time_ms", ColumnType.UInt64),
        new Column("end_time_ms", ColumnType.UInt64),
        new Column("duration_ms", ColumnType.UInt32),
        new Column("type", EnumColumnType.enum8(RequestType.class)),
        new Column("module", ColumnType.String),
        new Column("host", ColumnType.String),
        new Column("source_module", ColumnType.String),
        new Column("source_host", ColumnType.String),
        new Column("target_module", ColumnType.String),
        new Column("target_host", ColumnType.String),
        new Column("environment", EnumColumnType.enum8(Environment.class)),
        new Column("request_method", ColumnType.String),
        new Column("http_code", ColumnType.Int16),
        new Column("retry_num", ColumnType.UInt8),
        new Column("error_code", ColumnType.String),
        new Column("protocol", ColumnType.String),
        new Column("http_method", ColumnType.String),
        new Column("query_params", ColumnType.String),
        new Column("yandex_uid", ColumnType.String),
        new Column("yandex_login", ColumnType.String),
        new Column("kv_keys", ColumnType.ArrayString),
        new Column("kv_values", ColumnType.ArrayString),
        new Column("events_names", ColumnType.ArrayString),
        new Column("events_timestamps", ColumnType.ArrayUInt64),
        new Column("test_ids", ColumnType.ArrayUInt32),
        new Column("page_id", ColumnType.String),
        new Column("page_type", ColumnType.String),
        new Column("response_size_bytes", ColumnType.Int32, "-1")
    );

    private EnvironmentMapper environmentMapper = new EnvironmentMapper(EnvironmentMapper.LOGBROKER_PROTOCOL_PREFIX);

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    public Environment getEnvironment(ParserContext context) {
        return environmentMapper.getEnvironment(context);
    }
}
