package ru.yandex.market.logshatter.parser.trace;

import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.nginx.NginxTskvLogEntry;

import java.util.Optional;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 13/09/16
 */
public class NginxTraceLogParser extends AbstractTraceLogParser {

    private static final String[] EVENTS_KEYS = {
        "upstream"
    };


    @Override
    public void parse(String line, ParserContext context) throws Exception {
        NginxTskvLogEntry entry = new NginxTskvLogEntry(line, context.getPageMatcher());

        Optional<RequestId> requestId = RequestId.parseOptional(entry.getMarkerRequestId());
        if (!requestId.isPresent()) {
            return;
        }

        Long requestStartMillis = entry.getRequestEndTimeMillis() - entry.getClientReqTimeMillis();
        Long serverEndTimeMillis = requestStartMillis + entry.getRespTimeMillis();
        Long[] eventsTs = new Long[]{serverEndTimeMillis};

        String query = "";
        if (requestId.get().getIdSeq().length == 0) { //Пока пишем params только для первородного запроса
            query = entry.getUrl();
        }

        // В PROXY мы не знаем page_id и page_type источника запроса.
        String pageId = "";
        String pageType = "";

        context.write(
            requestId.get().getDate(), requestId.get().getIdMillis(),
            requestId.get().getIdHash(), requestId.get().getIdSeq(),
            requestStartMillis, entry.getRequestEndTimeMillis(), entry.getClientReqTimeMillis(),
            RequestType.PROXY, "nginx", context.getHost(),
            "", entry.getClientIp(), entry.getService(), entry.getUpstreamAddress(),
            getEnvironment(context), entry.getPageId(),
            entry.getHttpCode(), 1, "", entry.getScheme(), entry.getHttpMethod(),
            query, entry.getYandexUid(), entry.getYandexLogin(),
            EMPTY_ARRAY, EMPTY_ARRAY, EVENTS_KEYS, eventsTs,
            entry.getTestIds(), pageId, pageType, entry.getResponseSizeBytes()
        );
        //TODO entry.getUrl() вместо второго "". Пока убрано до оценки объемов.

    }

}
