package ru.yandex.market.logshatter.parser.trace;

import com.google.common.annotations.VisibleForTesting;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.marketout.ReportTskvLogEntry;
import ru.yandex.market.logshatter.parser.marketout.ReportLogParser;

import java.util.Optional;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 13/09/16
 */
public class ReportTraceLogParser extends AbstractTraceLogParser {

    @VisibleForTesting
    static final String REPORT_MODULE_ID = "market_report";

    @VisibleForTesting
    static final String[] KV_KEYS = {
        "place",
        "pp",
        "docProcessed",
        "docAccepted",
        "rendered",
        "searchMs",
        "baseSearchMs",
        "metaSearchMs",
        "reqWizMs"
    };

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        ReportTskvLogEntry entry = new ReportTskvLogEntry(line);
        if (!entry.isValid()) {
            return;
        }
        Optional<RequestId> requestId = RequestId.parseOptional(entry.getMarketRequestId());
        if (!requestId.isPresent()) {
            return;
        }

        final int requestFullTimeElapsedMillis = entry.getFullElapsedMillis();
        final Long requestStartTimeMillis = entry.getRequestStartTimeMillis();
        final Long requestStopTimeMillis = requestStartTimeMillis + requestFullTimeElapsedMillis;

        String[] kvValues = {
            entry.getPlace(),
            entry.getPP().toString(),
            entry.getTotalDocumentsProcessed().toString(),
            entry.getTotalDocumentsAccepted().toString(),
            entry.getTotalRendered().toString(),
            entry.getSearchElapsed().toString(),
            entry.getBaseSearchElapsed().toString(),
            entry.getMetaSearchElapsed().toString(),
            entry.getReqWizTimeMillis().toString()
        };

        context.write(
            requestId.get().getDate(), requestId.get().getIdMillis(), requestId.get().getIdHash(),
            requestId.get().getIdSeq(),
            requestStartTimeMillis, requestStopTimeMillis, requestFullTimeElapsedMillis,
            RequestType.IN, REPORT_MODULE_ID, context.getHost(),
            "", entry.getRemoteAddress(), REPORT_MODULE_ID, context.getHost(), getEnvironment(context),
            "GET", -1, 1, entry.getError(), "http", "", "", "", "",
            KV_KEYS, kvValues, EMPTY_ARRAY, EMPTY_ARRAY, entry.getTestIds(), "", "", -1
        );

    }
}
